/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.models;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.github.fabricators_of_create.porting_lib.core.PortingLib;
import io.github.fabricators_of_create.porting_lib.models.ModelLoader;
import io.github.fabricators_of_create.porting_lib.models.RenderMaterialDeserializer;
import io.github.fabricators_of_create.porting_lib.models.geometry.GeometryLoaderManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelResolver;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_793;
import org.jetbrains.annotations.Nullable;

public enum PortingLibModelLoadingRegistry implements ModelLoadingPlugin
{
    INSTANCE;

    public static final Map<class_2960, ModelLoader> LOADERS;
    public static final Gson GSON;

    public void onInitializeModelLoader(ModelLoadingPlugin.Context ctx) {
        ctx.resolveModel().register((Object)Resolver.INSTANCE);
    }

    public static BufferedReader getModelJson(class_2960 location) throws IOException {
        class_2960 file = new class_2960(location.method_12836(), "models/" + location.method_12832() + ".json");
        Optional resource = class_310.method_1551().method_1478().method_14486(file);
        return ((class_3298)resource.orElseThrow(() -> new FileNotFoundException(file.toString()))).method_43039();
    }

    static {
        LOADERS = new HashMap<class_2960, ModelLoader>();
        GSON = class_793.field_4254.newBuilder().registerTypeAdapter(RenderMaterial.class, (Object)new RenderMaterialDeserializer()).create();
    }

    private static enum Resolver implements ModelResolver
    {
        INSTANCE;


        @Nullable
        public class_1100 resolveModel(ModelResolver.Context context) {
            class_2960 modelId = context.id();
            if (modelId.method_12832().contains("builtin")) {
                return null;
            }
            try {
                JsonObject object = (JsonObject)GSON.fromJson((Reader)PortingLibModelLoadingRegistry.getModelJson(modelId), JsonObject.class);
                String loader = GeometryLoaderManager.getModelLoader((JsonObject)object);
                if (loader != null) {
                    class_2960 id = new class_2960(loader);
                    if (!LOADERS.containsKey(id)) {
                        return null;
                    }
                    class_793 ownerModel = class_793.method_3430((String)object.toString());
                    return LOADERS.get(id).readModel(ownerModel, object);
                }
            }
            catch (FileNotFoundException object) {
            }
            catch (Exception e) {
                PortingLib.LOGGER.error("Unhandled error loading model: " + String.valueOf(modelId), (Throwable)e);
            }
            return null;
        }
    }
}

